package com.biz.crm.mdm.cusorg;

import com.biz.crm.mdm.cusorg.impl.MdmCustomerOrgRedisFeignImpl;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgRedisVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgReloadRedisVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 客户组织表redis缓存数据查询feign接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmCustomerOrgRedisFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmCustomerOrgRedisFeignImpl.class)
public interface MdmCustomerOrgRedisFeign {

    /**
     * 根据客户组织编码集合获取客户组织详情redis缓存数据
     *
     * @param customerOrgCodeList
     * @return
     */
    @PostMapping("/mdmCustomerOrgRedisController/findRedisListByCustomerOrgCodeList")
    Result<List<MdmCustomerOrgRedisVo>> findRedisListByCustomerOrgCodeList(@RequestBody List<String> customerOrgCodeList);

    /**
     * 根据客户组织编码集合获取客户组织上级redis缓存数据
     *
     * @param customerOrgCodeList
     * @return
     */
    @PostMapping("/mdmCustomerOrgRedisController/findRedisCustomerOrgParentListByCodeList")
    Result<List<MdmCustomerOrgParentChildrenRedisVo>> findRedisCustomerOrgParentListByCodeList(@RequestBody List<String> customerOrgCodeList);

    /**
     * 根据客户组织编码集合获取客户组织下级redis缓存数据
     *
     * @param customerOrgCodeList
     * @return
     */
    @PostMapping("/mdmCustomerOrgRedisController/findRedisCustomerOrgChildrenListByCodeList")
    Result<List<MdmCustomerOrgParentChildrenRedisVo>> findRedisCustomerOrgChildrenListByCodeList(@RequestBody List<String> customerOrgCodeList);

    /**
     * 获取全部客户组织redis缓存数据
     *
     * @return
     */
    @PostMapping("/mdmCustomerOrgRedisController/findRedisReloadList")
    Result<List<MdmCustomerOrgReloadRedisVo>> findRedisReloadList();
}
