package com.biz.crm.mdm.cusorgbusowner;

import com.biz.crm.mdm.cusorgbusowner.impl.CusOrgbusownerFeignImpl;
import com.biz.crm.nebular.mdm.cusorgbusowner.CusOrgPosBusOwnerAddByCodesVo;
import com.biz.crm.nebular.mdm.cusorgbusowner.CusOrgPosBusOwnerAddByParamVo;
import com.biz.crm.nebular.mdm.cusorgbusowner.CusOrgPosBusOwnerRemoveVo;
import com.biz.crm.nebular.mdm.cusorgbusowner.ListVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/2 21:15
 **/
@FeignClient(url ="${feign.urlip:}",qualifier = "cusOrgbusownerFeign",name="crm-mdm",path = "mdm",fallbackFactory = CusOrgbusownerFeignImpl.class)
public interface CusOrgbusownerFeign {

    /**
     * TODO 没有验证一个职位只能属于一个组织,暂时是多对多关系，由项目自己判断
     * 客户组织批量关联业务归属(根据code关联)
     * @param cusOrgPosBusOwnerAddByCodesVo
     * @return
     */
    @PostMapping(value = "/cus/org/busowner/addByCodes")
    Result addByCodes(@RequestBody CusOrgPosBusOwnerAddByCodesVo cusOrgPosBusOwnerAddByCodesVo);


    /**
     * TODO 没有验证一个职位只能属于一个组织,暂时是多对多关系，由项目自己判断
     * 客户组织批量关联业务归属(根据查询条件关联)
     * @param cusOrgPosBusOwnerAddByParamVo
     * @return
     */
    @PostMapping(value = "/cus/org/busowner/addByParam")
    Result addByParam(@RequestBody CusOrgPosBusOwnerAddByParamVo cusOrgPosBusOwnerAddByParamVo);

    /**
     * 分页搜索客户组织关联的所有职位(根据参数区分是否关联)
     * @param listVo
     * @return
     */
    @PostMapping(value = "/cus/org/busowner/list")
    Result list(@RequestBody ListVo listVo);


    /**批量删除
     * @param cusOrgPosBusOwnerRemoveVo
     * @return
     */
    @PostMapping(value = "/cus/org/busowner/removeBatch")
    Result removeBatch(@RequestBody CusOrgPosBusOwnerRemoveVo cusOrgPosBusOwnerRemoveVo);
}
