package com.biz.crm.mdm.customer;

import com.biz.crm.mdm.customer.impl.MdmCustomerROrgFeignImpl;
import com.biz.crm.nebular.mdm.customer.MdmCustomerROrgReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 客户与组织关联表feign接口
 *
 * @author zxw
 * @date 2020-12-21 09:50:12
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmCustomerROrgFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmCustomerROrgFeignImpl.class)
public interface MdmCustomerROrgFeign {

    @ApiOperation("根据客户编码查询组织编码集合")
    @PostMapping("/mdmCustomerRelationOrgController/findOrgCodeListByCustomerCode")
    Result<List<String>> findOrgCodeListByCustomerCode(@RequestBody MdmCustomerROrgReqVo mdmCustomerROrgReqVo);
}
