package com.biz.crm.mdm.customer.impl;

import com.biz.crm.mdm.customer.MdmCustomerROrgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerROrgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerROrgRespVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import java.util.ArrayList;
import java.util.List;

/**
 * 客户与组织关联表feign接口熔断类
 *
 * @author zxw
 * @date 2020-12-21 09:50:12
 */
@Slf4j
@Component
public class MdmCustomerROrgFeignImpl extends BaseAbstract implements FallbackFactory<MdmCustomerROrgFeign> {

    @Override
    public MdmCustomerROrgFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmCustomerROrgFeign() {

            @Override
            public Result<List<String>> findOrgCodeListByCustomerCode(MdmCustomerROrgReqVo mdmCustomerROrgReqVo) {
                return doBack();
            }
        };
    }
}
