package com.biz.crm.mdm.engineform.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.engineform.EngineFormListTemplateFeign;
import com.biz.crm.nebular.mdm.engineform.req.EngineFormListTemplateReqVo;
import com.biz.crm.nebular.mdm.engineform.resp.EngineFormListTemplateRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 表单引擎模板的数据层描述feign接口熔断类
 *
 * @author huanglong
 * @date 2020-11-17 09:25:34
 */
@Slf4j
@Component
public class EngineFormListTemplateFeignImpl extends BaseAbstract implements FallbackFactory<EngineFormListTemplateFeign> {

    @Override
    public EngineFormListTemplateFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new EngineFormListTemplateFeign() {
            /**
             * 列表
             */
            @Override
            public Result<PageResult<EngineFormListTemplateRespVo>> list(EngineFormListTemplateReqVo engineFormListTemplateReqVo) {
                doBack();
                PageResult<EngineFormListTemplateRespVo> build = PageResult.<EngineFormListTemplateRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<EngineFormListTemplateRespVo> query(EngineFormListTemplateReqVo engineFormListTemplateReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(EngineFormListTemplateReqVo engineFormListTemplateReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(EngineFormListTemplateReqVo engineFormListTemplateReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(EngineFormListTemplateReqVo engineFormListTemplateReqVo) {
                return doBack();
            }

            @Override
            public Result activityFormList() {
                return doBack();
            }
        };
    }
}
