package com.biz.crm.mdm.function.impl;

import com.biz.crm.mdm.function.MdmFunctionFeign;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import java.util.ArrayList;
import java.util.List;

/**
 * 菜单表feign接口熔断类
 *
 * @author zxw
 * @date 2020-11-18 10:26:31
 */
@Slf4j
@Component
public class MdmFunctionFeignImpl extends BaseAbstract implements FallbackFactory<MdmFunctionFeign> {

    @Override
    public MdmFunctionFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmFunctionFeign() {
             /**
              * 列表
              */
            @Override
            public Result<List<MdmFunctionRespVo>> list(MdmFunctionReqVo mdmFunctionReqVo) {
                return doBack();
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmFunctionRespVo> query(MdmFunctionReqVo mdmFunctionReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmFunctionReqVo mdmFunctionReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmFunctionReqVo mdmFunctionReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmFunctionReqVo mdmFunctionReqVo) {
                return doBack();
            }

        };
    }
}
