package com.biz.crm.mdm.org;

import com.biz.crm.mdm.org.impl.MdmOrgRedisFeignImpl;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgReloadRedisVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 组织表redis缓存数据查询feign接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmOrgRedisFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmOrgRedisFeignImpl.class)
public interface MdmOrgRedisFeign {

    /**
     * 根据组织编码集合获取组织详情redis缓存数据
     *
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmOrgRedisController/findRedisListByOrgCodeList")
    Result<List<MdmOrgRedisVo>> findRedisListByOrgCodeList(@RequestBody List<String> orgCodeList);

    /**
     * 根据组织编码集合获取组织上级redis缓存数据
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmOrgRedisController/findRedisOrgParentListByCodeList")
    Result<List<MdmOrgParentChildrenRedisVo>> findRedisOrgParentListByCodeList(@RequestBody List<String> orgCodeList);

    /**
     * 根据组织编码集合获取组织下级redis缓存数据
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmOrgRedisController/findRedisOrgChildrenListByCodeList")
    Result<List<MdmOrgParentChildrenRedisVo>> findRedisOrgChildrenListByCodeList(@RequestBody List<String> orgCodeList);

    /**
     * 获取全部组织redis缓存数据
     * @return
     */
    @PostMapping("/mdmOrgRedisController/findRedisReloadList")
    Result<List<MdmOrgReloadRedisVo>> findRedisReloadList();
}
