package com.biz.crm.mdm.org.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.org.MdmOrgRedisFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgReloadRedisVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 组织表feign接口熔断类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@Component
public class MdmOrgRedisFeignImpl extends BaseAbstract implements FallbackFactory<MdmOrgRedisFeign> {

    @Override
    public MdmOrgRedisFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmOrgRedisFeign() {

            @Override
            public Result<List<MdmOrgRedisVo>> findRedisListByOrgCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgParentChildrenRedisVo>> findRedisOrgParentListByCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgParentChildrenRedisVo>> findRedisOrgChildrenListByCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmOrgReloadRedisVo>> findRedisReloadList() {
                return doBack();
            }

        };
    }
}
