package com.biz.crm.mdm.permission;


import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.permission.impl.MdmDataPermissionFeignImpl;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionReqVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionSetVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 数据权限feign接口
 *
 * @author zxw
 * @date 2020-10-26 12:09:31
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmDataPermissionFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmDataPermissionFeignImpl.class)
public interface MdmDataPermissionFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmdatapermission/list")
    Result<PageResult<MdmDataPermissionRespVo>> list(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmdatapermission/query")
    Result<MdmDataPermissionRespVo> query(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmdatapermission/save")
    Result save(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmdatapermission/update")
    Result update(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmdatapermission/delete")
    Result delete(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmdatapermission/enable")
    Result enable(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmdatapermission/disable")
    Result disable(@RequestBody  MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 获取当前用户的数据权限
     * @param competenceCode
     * @param listConfigCode
     * @return
     */
    @PostMapping("/mdmDataPermissionController/currentUserDataPermission")
    Result<MdmCurrentPermissionRespVo> currentUserDataPermission(@RequestParam("competenceCode") String competenceCode, @RequestParam("listConfigCode")  String listConfigCode);


    @ApiOperation("获取当前用户权限sql")
    @PostMapping("/mdmDataPermissionController/currentUserPermissionSql")
    Result<List<MdmPermissionSetVo>> currentUserPermissionSql();
}
