package com.biz.crm.mdm.priceconditiongroup;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionGroupReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.mdm.priceconditiongroup.impl.MdmPriceConditionGroupFeignImpl;

import java.util.List;

/**
 * 条件字段分类主表 feign接口
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmPriceConditionGroupFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmPriceConditionGroupFeignImpl.class)
public interface MdmPriceConditionGroupFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmpriceconditiongroup/list")
    Result<PageResult<MdmPriceConditionGroupRespVo>> list(@RequestBody MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmpriceconditiongroup/query")
    Result<MdmPriceConditionGroupRespVo> query(@RequestBody MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmpriceconditiongroup/save")
    Result save(@RequestBody MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmpriceconditiongroup/update")
    Result update(@RequestBody MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmpriceconditiongroup/delete")
    Result delete(@RequestBody MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmpriceconditiongroup/enable")
    Result enable(@RequestBody MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmpriceconditiongroup/disable")
    Result disable(@RequestBody MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);

    /**
     * 查询集合
     */
    @PostMapping("/mdmpriceconditiongroup/findConllection")
    Result<List<MdmPriceConditionGroupRespVo>> findConllection(@RequestBody MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);
}
