package com.biz.crm.mdm.priceconditiontype.impl;

import com.biz.crm.mdm.priceconditiontype.MdmPriceConditionTypeFeign;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionTypeRelGroupRespVo;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionTypeRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionTypeReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;
import java.util.List;

/**
 * 条件字段类型主表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-10-20 10:57:00
 */
@Slf4j
@Component
public class MdmPriceConditionTypeFeignImpl extends BaseAbstract implements FallbackFactory<MdmPriceConditionTypeFeign> {

    @Override
    public MdmPriceConditionTypeFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmPriceConditionTypeFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<MdmPriceConditionTypeRespVo>> list(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo) {
                doBack();
                PageResult<MdmPriceConditionTypeRespVo> build = PageResult.<MdmPriceConditionTypeRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmPriceConditionTypeRespVo> query(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo) {
                return doBack();
            }

            /**
             * 根据条件类型编码查询条件分类数据
             * @param mdmPriceConditionTypeReqVo
             * @return
             */
            @Override
            public Result<List<MdmPriceConditionTypeRelGroupRespVo>> groupByConditionType(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo) {
                return doBack();
            }
        };
    }
}
