package com.biz.crm.mdm.priceconditiontype.impl;

import com.biz.crm.mdm.priceconditiontype.MdmPriceConditionTypeRelGroupFeign;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionTypeRelGroupRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionTypeRelGroupReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 条件字段类型和条件字段分类的关系表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-10-20 10:57:01
 */
@Slf4j
@Component
public class MdmPriceConditionTypeRelGroupFeignImpl extends BaseAbstract implements FallbackFactory<MdmPriceConditionTypeRelGroupFeign> {

    @Override
    public MdmPriceConditionTypeRelGroupFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmPriceConditionTypeRelGroupFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<MdmPriceConditionTypeRelGroupRespVo>> list(MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo) {
                doBack();
                PageResult<MdmPriceConditionTypeRelGroupRespVo> build = PageResult.<MdmPriceConditionTypeRelGroupRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmPriceConditionTypeRelGroupRespVo> query(MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo) {
                return doBack();
            }
        };
    }
}
