package com.biz.crm.mdm.productlevel;

import com.biz.crm.mdm.productlevel.impl.MdmProductLevelRedisFeignImpl;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRedisVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelReloadRedisVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 产品层级表redis缓存数据查询feign接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmProductLevelRedisFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmProductLevelRedisFeignImpl.class)
public interface MdmProductLevelRedisFeign {

    /**
     * 根据产品层级编码集合获取产品层级详情redis缓存数据
     *
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmProductLevelRedisController/findRedisListByProductLevelCodeList")
    Result<List<MdmProductLevelRedisVo>> findRedisListByProductLevelCodeList(@RequestBody List<String> orgCodeList);

    /**
     * 根据产品层级编码集合获取产品层级上级redis缓存数据
     *
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmProductLevelRedisController/findRedisProductLevelParentListByCodeList")
    Result<List<MdmProductLevelParentChildrenRedisVo>> findRedisProductLevelParentListByCodeList(@RequestBody List<String> orgCodeList);

    /**
     * 根据产品层级编码集合获取产品层级下级redis缓存数据
     *
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmProductLevelRedisController/findRedisProductLevelChildrenListByCodeList")
    Result<List<MdmProductLevelParentChildrenRedisVo>> findRedisProductLevelChildrenListByCodeList(@RequestBody List<String> orgCodeList);

    /**
     * 获取全部产品层级redis缓存数据
     *
     * @return
     */
    @PostMapping("/mdmProductLevelRedisController/findRedisReloadList")
    Result<List<MdmProductLevelReloadRedisVo>> findRedisReloadList();
}
