package com.biz.crm.mdm.productlevel.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.productlevel.MdmProductLevelRedisFeign;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRedisVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelReloadRedisVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 产品层级表feign接口熔断类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@Component
public class MdmProductLevelRedisFeignImpl extends BaseAbstract implements FallbackFactory<MdmProductLevelRedisFeign> {

    @Override
    public MdmProductLevelRedisFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmProductLevelRedisFeign() {

            @Override
            public Result<List<MdmProductLevelRedisVo>> findRedisListByProductLevelCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmProductLevelParentChildrenRedisVo>> findRedisProductLevelParentListByCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmProductLevelParentChildrenRedisVo>> findRedisProductLevelChildrenListByCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmProductLevelReloadRedisVo>> findRedisReloadList() {
                return doBack();
            }

        };
    }
}
