package com.biz.crm.mdm.region;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.region.impl.MdmRegionFeignImpl;
import com.biz.crm.nebular.mdm.region.MdmRegionReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * feign接口
 *
 * @author zxw
 * @date 2020-11-20 14:59:37
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "MdmRegionFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmRegionFeignImpl.class)
public interface MdmRegionFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmregion/list")
    Result<PageResult<MdmRegionRespVo>> list(@RequestBody MdmRegionReqVo mdmRegionReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmregion/query")
    Result<MdmRegionRespVo> query(@RequestBody MdmRegionReqVo mdmRegionReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmregion/save")
    Result save(@RequestBody MdmRegionReqVo mdmRegionReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmregion/update")
    Result update(@RequestBody MdmRegionReqVo mdmRegionReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmregion/delete")
    Result delete(@RequestBody MdmRegionReqVo mdmRegionReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmregion/enable")
    Result enable(@RequestBody MdmRegionReqVo mdmRegionReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmregion/disable")
    Result disable(@RequestBody MdmRegionReqVo mdmRegionReqVo);

    /**
     * 区域下拉框
     *
     * @param mdmRegionReqVo vo
     * @return list
     */
    @PostMapping("/mdmregion/select")
    Result<List<MdmRegionSelectRespVo>> select(@RequestBody MdmRegionReqVo mdmRegionReqVo);
}
