package com.biz.crm.mdm.region.impl;

import com.biz.crm.mdm.region.MdmRegionFeign;
import com.biz.crm.nebular.mdm.region.MdmRegionReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectRespVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import java.util.ArrayList;
import java.util.List;

/**
 * feign接口熔断类
 *
 * @author zxw
 * @date 2020-11-20 14:59:37
 */
@Slf4j
@Component
public class MdmRegionFeignImpl extends BaseAbstract implements FallbackFactory<MdmRegionFeign> {

    @Override
    public MdmRegionFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmRegionFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<MdmRegionRespVo>> list(MdmRegionReqVo mdmRegionReqVo) {
                doBack();
                PageResult<MdmRegionRespVo> build = PageResult.<MdmRegionRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmRegionRespVo> query(MdmRegionReqVo mdmRegionReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmRegionReqVo mdmRegionReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmRegionReqVo mdmRegionReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmRegionReqVo mdmRegionReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmRegionReqVo mdmRegionReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmRegionReqVo mdmRegionReqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmRegionSelectRespVo>> select(MdmRegionReqVo mdmRegionReqVo) {
                return doBack();
            }
        };
    }
}
