package com.biz.crm.mdm.terminal;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.mdm.terminal.impl.MdmTerminalCallBackFeignImpl;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 终端信息审批回调feign接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmTerminalCallBackFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmTerminalCallBackFeignImpl.class)
public interface MdmTerminalCallBackFeign extends CallbackFeign {

    /**
     * 回调方法
     *
     * @param activitiCallBackVo
     * @return
     */
    @Override
    @PostMapping("/mdmTerminalController/activityCallBack")
    Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo);
}
