package com.biz.crm.mdm.user.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerRelCustomerUserReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangeHeadReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.ArrayList;
import java.util.List;

/**
 * 用户信息表feign接口熔断类
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Slf4j
@Component
public class MdmUserFeignImpl extends BaseAbstract implements FallbackFactory<MdmUserFeign> {

    @Override
    public MdmUserFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmUserFeign() {

            @Override
            public Result<List<MdmUserRespVo>> listDetail(@RequestBody MdmUserReqVo mdmUserReqVo) {
                return doBack();
            }

            @Override
            public Result changeUserHeadUrl(MdmUserChangeHeadReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmUserRespVo>> findCustomerRelCustomerUserList(MdmCustomerRelCustomerUserReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<MdmUserRespVo> query(MdmUserReqVo mdmUserReqVo) {
                return doBack();
            }

            @Override
            public Result changePassword(MdmUserChangePasswordReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmUserPageRespVo>> pageList(MdmUserPageReqVo reqVo) {
                return doBack();
            }
        };
    }
}
