package com.biz.crm.sfa.activity;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityRangeReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityRangeRespVo;
import com.biz.crm.sfa.activity.impl.SfaActivityRangeFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 活动执行范围;feign接口
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaActivityRangeFeign",name="crm-sfa",path = "tpm",fallbackFactory = SfaActivityRangeFeignImpl.class)
public interface SfaActivityRangeFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaactivityrange/list")
    Result<PageResult<SfaActivityRangeRespVo>> list(@RequestBody SfaActivityRangeReqVo sfaActivityRangeReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaactivityrange/query")
    Result<SfaActivityRangeRespVo> query(@RequestBody SfaActivityRangeReqVo sfaActivityRangeReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaactivityrange/save")
    Result save(@RequestBody SfaActivityRangeReqVo sfaActivityRangeReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaactivityrange/update")
    Result update(@RequestBody SfaActivityRangeReqVo sfaActivityRangeReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaactivityrange/delete")
    Result delete(@RequestBody SfaActivityRangeReqVo sfaActivityRangeReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaactivityrange/enable")
    Result enable(@RequestBody SfaActivityRangeReqVo sfaActivityRangeReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaactivityrange/disable")
    Result disable(@RequestBody  SfaActivityRangeReqVo sfaActivityRangeReqVo);
}
