package com.biz.crm.sfa.activity.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityRangeReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityRangeRespVo;
import com.biz.crm.sfa.activity.SfaActivityRangeFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 活动执行范围;feign接口熔断类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@Component
public class SfaActivityRangeFeignImpl extends BaseAbstract implements FallbackFactory<SfaActivityRangeFeign> {

    @Override
    public SfaActivityRangeFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaActivityRangeFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaActivityRangeRespVo>> list(SfaActivityRangeReqVo sfaActivityRangeReqVo) {
                doBack();
                PageResult<SfaActivityRangeRespVo> build = PageResult.<SfaActivityRangeRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaActivityRangeRespVo> query(SfaActivityRangeReqVo sfaActivityRangeReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaActivityRangeReqVo sfaActivityRangeReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaActivityRangeReqVo sfaActivityRangeReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaActivityRangeReqVo sfaActivityRangeReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaActivityRangeReqVo sfaActivityRangeReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaActivityRangeReqVo sfaActivityRangeReqVo) {
                return doBack();
            }
        };
    }
}
