package com.biz.crm.sfa.assistant;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaVisitStepAbnormalReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaVisitStepAbnormalRespVo;
import com.biz.crm.sfa.assistant.impl.SfaVisitStepAbnormalFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访（异常提报） feign接口
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaVisitStepAbnormalFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaVisitStepAbnormalFeignImpl.class)
public interface SfaVisitStepAbnormalFeign {

    /**
     * 列表
     */
    @PostMapping("/sfavisitstepabnormal/list")
    Result<PageResult<SfaVisitStepAbnormalRespVo>> list(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfavisitstepabnormal/query")
    Result<SfaVisitStepAbnormalRespVo> query(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfavisitstepabnormal/save")
    Result save(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfavisitstepabnormal/update")
    Result update(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfavisitstepabnormal/delete")
    Result delete(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfavisitstepabnormal/enable")
    Result enable(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfavisitstepabnormal/disable")
    Result disable(@RequestBody SfaVisitStepAbnormalReqVo sfaVisitStepAbnormalReqVo);
}
