package com.biz.crm.sfa.assistant.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryRespVo;
import com.biz.crm.sfa.assistant.SfaWorkSummaryFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 工作总结 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@Component
public class SfaWorkSummaryFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkSummaryFeign> {

    @Override
    public SfaWorkSummaryFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkSummaryFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaWorkSummaryRespVo>> list(SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
                doBack();
                PageResult<SfaWorkSummaryRespVo> build = PageResult.<SfaWorkSummaryRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaWorkSummaryRespVo> query(SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
                return doBack();
            }
        };
    }
}
