package com.biz.crm.sfa.assistant.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReleaseReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReleaseRespVo;
import com.biz.crm.sfa.assistant.SfaWorkTaskReleaseFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 工作任务(发布) feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Slf4j
@Component
public class SfaWorkTaskReleaseFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkTaskReleaseFeign> {

    @Override
    public SfaWorkTaskReleaseFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkTaskReleaseFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaWorkTaskReleaseRespVo>> list(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo) {
                doBack();
                PageResult<SfaWorkTaskReleaseRespVo> build = PageResult.<SfaWorkTaskReleaseRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaWorkTaskReleaseRespVo> query(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo) {
                return doBack();
            }
        };
    }
}
