package com.biz.crm.sfa.calculateSalary.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaCalculateSalaryYearReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryYearRespVo;
import com.biz.crm.sfa.calculateSalary.SfaCalculateSalaryYearFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 计算薪资年 feign接口熔断类
 *
 * @author lf
 * @date 2020-12-28 15:00:09
 */
@Slf4j
@Component
public class SfaCalculateSalaryYearFeignImpl extends BaseAbstract implements FallbackFactory<SfaCalculateSalaryYearFeign> {

    @Override
    public SfaCalculateSalaryYearFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaCalculateSalaryYearFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaCalculateSalaryYearRespVo>> list(SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo) {
                doBack();
                PageResult<SfaCalculateSalaryYearRespVo> build = PageResult.<SfaCalculateSalaryYearRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaCalculateSalaryYearRespVo> query(SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaCalculateSalaryYearReqVo sfaCalculateSalaryYearReqVo) {
                return doBack();
            }
        };
    }
}
