package com.biz.crm.sfa.collection;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.collection.req.SfaDirectoryInputReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaDirectoryInputRespVo;
import com.biz.crm.sfa.collection.impl.SfaDirectoryInputFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 拜访步骤 -控件目录信息明细 feign接口
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaDirectoryInputFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaDirectoryInputFeignImpl.class)
public interface SfaDirectoryInputFeign {

    /**
     * 列表
     */
    @PostMapping("/sfadirectoryinput/list")
    Result<PageResult<SfaDirectoryInputRespVo>> list(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfadirectoryinput/query")
    Result<SfaDirectoryInputRespVo> query(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfadirectoryinput/save")
    Result save(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfadirectoryinput/update")
    Result update(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfadirectoryinput/delete")
    Result delete(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfadirectoryinput/enable")
    Result enable(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfadirectoryinput/disable")
    Result disable(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo);
}
