package com.biz.crm.sfa.freesignconfig;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignPersonnelReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignPersonnelRespVo;
import com.biz.crm.sfa.freesignconfig.impl.SfaFreesignPersonnelFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 签到组-打卡人员 feign接口
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaFreesignPersonnelFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaFreesignPersonnelFeignImpl.class)
public interface SfaFreesignPersonnelFeign {

    /**
     * 列表
     */
    @PostMapping("/sfafreesignpersonnel/list")
    Result<PageResult<SfaFreesignPersonnelRespVo>> list(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfafreesignpersonnel/query")
    Result<SfaFreesignPersonnelRespVo> query(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfafreesignpersonnel/save")
    Result save(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfafreesignpersonnel/update")
    Result update(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfafreesignpersonnel/delete")
    Result delete(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfafreesignpersonnel/enable")
    Result enable(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfafreesignpersonnel/disable")
    Result disable(@RequestBody SfaFreesignPersonnelReqVo sfaFreesignPersonnelReqVo);
}
