package com.biz.crm.sfa.notice;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeRespVo;
import com.biz.crm.sfa.notice.impl.SfaNoticeFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 公告管理 feign接口
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:42
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaNoticeFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaNoticeFeignImpl.class)
public interface SfaNoticeFeign {

    /**
     * 列表
     */
    @PostMapping("/sfanotice/list")
    Result<PageResult<SfaNoticeRespVo>> list(@RequestBody SfaNoticeReqVo sfaNoticeReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfanotice/query")
    Result<SfaNoticeRespVo> query(@RequestBody SfaNoticeReqVo sfaNoticeReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfanotice/save")
    Result save(@RequestBody SfaNoticeReqVo sfaNoticeReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfanotice/update")
    Result update(@RequestBody SfaNoticeReqVo sfaNoticeReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfanotice/delete")
    Result delete(@RequestBody SfaNoticeReqVo sfaNoticeReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfanotice/enable")
    Result enable(@RequestBody SfaNoticeReqVo sfaNoticeReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfanotice/disable")
    Result disable(@RequestBody SfaNoticeReqVo sfaNoticeReqVo);
}
