package com.biz.crm.sfa.notice.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeRespVo;
import com.biz.crm.sfa.notice.SfaNoticeFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 公告管理 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:42
 */
@Slf4j
@Component
public class SfaNoticeFeignImpl extends BaseAbstract implements FallbackFactory<SfaNoticeFeign> {

    @Override
    public SfaNoticeFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaNoticeFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaNoticeRespVo>> list(SfaNoticeReqVo sfaNoticeReqVo) {
                doBack();
                PageResult<SfaNoticeRespVo> build = PageResult.<SfaNoticeRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaNoticeRespVo> query(SfaNoticeReqVo sfaNoticeReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaNoticeReqVo sfaNoticeReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaNoticeReqVo sfaNoticeReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaNoticeReqVo sfaNoticeReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaNoticeReqVo sfaNoticeReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaNoticeReqVo sfaNoticeReqVo) {
                return doBack();
            }
        };
    }
}
