package com.biz.crm.sfa.sfajob;

import com.biz.crm.sfa.notice.impl.SfaNoticeFeignImpl;
import com.biz.crm.sfa.sfajob.impl.SfaJobFeignImpl;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.sfa.sfajob
 * @date 2021/7/30 15:41
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "SfaJobFeign", name = "crm-sfa", path = "sfa", fallbackFactory = SfaJobFeignImpl.class)
public interface SfaJobFeign {

    @ApiOperation(value = "拜访计划结算任务")
    @GetMapping("/sfaJobController/visitPlanInfoSettlementDoJob")
    Result visitPlanInfoSettlementDoJob();


    @ApiOperation(value = "拜访日进度结算任务开始")
    @GetMapping("/sfaJobController/planInfoSettlementForJob")
    Result planInfoSettlementForJob();


    @ApiOperation(value = "任务过期定时任务")
    @GetMapping("/sfaJobController/executeWorkSignRule")
    Result executeWorkSignRule();

    @ApiOperation(value = "每月定时拉取职位增加积分")
    @GetMapping("/sfaJobController/saveIntegralDetailByMonth")
    Result saveIntegralDetailByMonth();


    @ApiOperation(value = "活动明细任务解析")
    @GetMapping("/sfaJobController/resolveSfaVisitActivityExecute")
    Result resolveSfaVisitActivityExecute();

    @ApiOperation(value = "解析拜访计划明细")
    @GetMapping("/sfaJobController/executeSfaVisitPlan")
    Result executeSfaVisitPlan();
}

