package com.biz.crm.sfa.visitstep.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitDisplayConfigReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitDisplayConfigRespVo;
import com.biz.crm.sfa.visitstep.SfaVisitDisplayConfigFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 拜访(陈列执行配置) feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Slf4j
@Component
public class SfaVisitDisplayConfigFeignImpl extends BaseAbstract implements FallbackFactory<SfaVisitDisplayConfigFeign> {

    @Override
    public SfaVisitDisplayConfigFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaVisitDisplayConfigFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaVisitDisplayConfigRespVo>> list(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
                doBack();
                PageResult<SfaVisitDisplayConfigRespVo> build = PageResult.<SfaVisitDisplayConfigRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaVisitDisplayConfigRespVo> query(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaVisitDisplayConfigReqVo sfaVisitDisplayConfigReqVo) {
                return doBack();
            }
        };
    }
}
