package com.biz.crm.sfa.visitstep.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActTableRespVo;
import com.biz.crm.sfa.visitstep.SfaVisitStepTpmActivityFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author yangshan
 * @date 2021/6/17 14:52
 */
@Slf4j
@Component
public class SfaVisitStepTpmActivityFeignImpl extends BaseAbstract implements FallbackFactory< SfaVisitStepTpmActivityFeign> {
    @Override
    public SfaVisitStepTpmActivityFeign create(Throwable cause) {
        log.error("进入熔断",cause);
        return new SfaVisitStepTpmActivityFeign() {

            /**
             * tpm活动-根据活动明细编码查询活动执行数据
             *
             * @param actDetailCode
             * @return
             */
            @Override
            public Result<List<SfaTpmActCollectVo>> getTpmActExecuteDataByActDetailCode(String actDetailCode) {
                return doBack();
            }

            /**
             * tpm活动-执行数据明细报表详情
             *
             * @param id
             * @return
             */
            @Override
            public Result<SfaTpmActTableRespVo> loadTpmActCollectDetailTableById(String id) {
                return doBack();
            }
        };
    }
}
