package com.biz.crm.sfa.worksign;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.sfa.worksign.impl.SfaWorkSignTravelEndFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author ren.gang
 * @ClassName SfaWorkSignTravelEndFeign.java
 * @Description 出差审批流程结束
 * @createTime 2021年01月07日 17:43:00
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSignTravelEndFeign"
        ,name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSignTravelEndFeignImpl.class)
public interface SfaWorkSignTravelEndFeign extends CallbackFeign {

    /**
     * 流程结束
     * @param activitiCallBackVo
     * @return
     */
    @PostMapping("/sfaWorkSignAudit/travelEnd")
    Result callback(ActivitiCallBackVo activitiCallBackVo);
}
