package com.biz.crm.sfa.worksign.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignPictureReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignPictureRespVo;
import com.biz.crm.sfa.worksign.SfaWorkSignPictureFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 考勤照片 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Slf4j
@Component
public class SfaWorkSignPictureFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkSignPictureFeign> {

    @Override
    public SfaWorkSignPictureFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkSignPictureFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaWorkSignPictureRespVo>> list(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo) {
                doBack();
                PageResult<SfaWorkSignPictureRespVo> build = PageResult.<SfaWorkSignPictureRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaWorkSignPictureRespVo> query(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaWorkSignPictureReqVo sfaWorkSignPictureReqVo) {
                return doBack();
            }
        };
    }
}
