package com.biz.crm.sfa.worksignrule;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignTimeReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignTimeRespVo;
import com.biz.crm.sfa.worksignrule.impl.SfaWorkSignTimeFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 考勤规则-打卡时间;feign接口
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "SfaWorkSignTimeFeign",name="crm-sfa",path = "sfa",fallbackFactory = SfaWorkSignTimeFeignImpl.class)
public interface SfaWorkSignTimeFeign {

    /**
     * 列表
     */
    @PostMapping("/sfaworksigntime/list")
    Result<PageResult<SfaWorkSignTimeRespVo>> list(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 查询
     */
    @PostMapping("/sfaworksigntime/query")
    Result<SfaWorkSignTimeRespVo> query(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 新增
     */
    @PostMapping("/sfaworksigntime/save")
    Result save(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 更新
     */
    @PostMapping("/sfaworksigntime/update")
    Result update(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 删除
     */
    @PostMapping("/sfaworksigntime/delete")
    Result delete(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 启用
     */
    @PostMapping("/sfaworksigntime/enable")
    Result enable(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 禁用
     */
    @PostMapping("/sfaworksigntime/disable")
    Result disable(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);
}
