package com.biz.crm.tpm.act;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.act.resp.TmpActFeeShareRespVo;
import com.biz.crm.nebular.tpm.act.req.TmpActFeeShareReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.tpm.act.impl.TmpActFeeShareFeignImpl;

/**
 * 活动费用分摊表;feign接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TmpActFeeShareFeign",name="crm-tpm",path = "tpm",fallbackFactory = TmpActFeeShareFeignImpl.class)
public interface TmpActFeeShareFeign {

    /**
     * 列表
     */
    @PostMapping("/tmpactfeeshare/list")
    Result<PageResult<TmpActFeeShareRespVo>> list(@RequestBody TmpActFeeShareReqVo tmpActFeeShareReqVo);

    /**
     * 查询
     */
    @PostMapping("/tmpactfeeshare/query")
    Result<TmpActFeeShareRespVo> query(@RequestBody TmpActFeeShareReqVo tmpActFeeShareReqVo);

    /**
     * 新增
     */
    @PostMapping("/tmpactfeeshare/save")
    Result save(@RequestBody TmpActFeeShareReqVo tmpActFeeShareReqVo);

    /**
     * 更新
     */
    @PostMapping("/tmpactfeeshare/update")
    Result update(@RequestBody TmpActFeeShareReqVo tmpActFeeShareReqVo);

    /**
     * 删除
     */
    @PostMapping("/tmpactfeeshare/delete")
    Result delete(@RequestBody TmpActFeeShareReqVo tmpActFeeShareReqVo);

    /**
     * 启用
     */
    @PostMapping("/tmpactfeeshare/enable")
    Result enable(@RequestBody TmpActFeeShareReqVo tmpActFeeShareReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tmpactfeeshare/disable")
    Result disable(@RequestBody TmpActFeeShareReqVo tmpActFeeShareReqVo);
}
