package com.biz.crm.tpm.act.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.act.resp.TpmActBudgetRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.act.TpmActBudgetFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;

/**
 * 活动预算信息表;feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@Component
public class TpmActBudgetFeignImpl extends BaseAbstract implements FallbackFactory<TpmActBudgetFeign> {

    @Override
    public TpmActBudgetFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmActBudgetFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmActBudgetRespVo>> list(TpmActBudgetReqVo tpmActBudgetReqVo) {
                doBack();
                PageResult<TpmActBudgetRespVo> build = PageResult.<TpmActBudgetRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmActBudgetRespVo> query(TpmActBudgetReqVo tpmActBudgetReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmActBudgetReqVo tpmActBudgetReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmActBudgetReqVo tpmActBudgetReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmActBudgetReqVo tpmActBudgetReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmActBudgetReqVo tpmActBudgetReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmActBudgetReqVo tpmActBudgetReqVo) {
                return doBack();
            }
        };
    }
}
