package com.biz.crm.tpm.act.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.tpm.act.TpmActCallBackFeign;
import com.biz.crm.tpm.act.TpmActFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 活动提交审批回调;feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@Component
public class TpmActCallBackFeignImpl extends BaseAbstract implements FallbackFactory<TpmActCallBackFeign> {

    @Override
    public TpmActCallBackFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmActCallBackFeign() {
            @Override
            public Result callback(ActivitiCallBackVo activitiCallBackVo) {
                return doBack();
            }
        };
    }
}
