package com.biz.crm.tpm.act.impl;

import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.act.TpmActFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * 活动信息主表;feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@Component
public class TpmActFeignImpl extends BaseAbstract implements FallbackFactory<TpmActFeign> {

    @Override
    public TpmActFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmActFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmActRespVo>> list(TpmActReqVo tpmActReqVo) {
                doBack();
                PageResult<TpmActRespVo> build = PageResult.<TpmActRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmActRespVo> query(String id) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmActReqVo tpmActReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmActReqVo tpmActReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmActReqVo tpmActReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmActReqVo tpmActReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmActReqVo tpmActReqVo) {
                return doBack();
            }

            @Override
            public Result approve(TpmActReqVo tpmActReqVo) {
                return doBack();
            }

            /**
             * 活动新增根据选定的费用预算维度查询活动大类
             */
            @Override
            public Result<List<TpmCostTypeCategoriesRespVo>> getCategoriesByBudget(ActGetCategoriesByBudgetReqVo reqVo) {
                return doBack();
            }

            /**
             * 跟据活动大类查出活动细类集合
             */
            @Override
            public Result<List<TpmCostTypeFineRespVo>> getCategoryFinesByCategoryCode(TpmActDetailReqVo tpmActDetailReqVo) {
                return doBack();
            }
        };
    }
}
