package com.biz.crm.tpm.auditcollectexample;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExampleReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.auditcollectexample.impl.TpmAuditCollectExampleFeignImpl;

/**
 * 核销采集示例主表 feign接口
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmAuditCollectExampleFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmAuditCollectExampleFeignImpl.class)
public interface TpmAuditCollectExampleFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmauditcollectexample/list")
    Result<PageResult<TpmAuditCollectExampleRespVo>> list(@RequestBody TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmauditcollectexample/query")
    Result<TpmAuditCollectExampleRespVo> query(@RequestBody TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmauditcollectexample/save")
    Result save(@RequestBody TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmauditcollectexample/update")
    Result update(@RequestBody TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmauditcollectexample/delete")
    Result delete(@RequestBody TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmauditcollectexample/enable")
    Result enable(@RequestBody TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmauditcollectexample/disable")
    Result disable(@RequestBody TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo);
}
