package com.biz.crm.tpm.auditcollectexample.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExamplePictureRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExamplePictureReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.auditcollectexample.TpmAuditCollectExamplePictureFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;

/**
 * 核销采集示例图片表 feign接口熔断类
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
@Slf4j
@Component
public class TpmAuditCollectExamplePictureFeignImpl extends BaseAbstract implements FallbackFactory<TpmAuditCollectExamplePictureFeign> {

    @Override
    public TpmAuditCollectExamplePictureFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmAuditCollectExamplePictureFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmAuditCollectExamplePictureRespVo>> list(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo) {
                doBack();
                PageResult<TpmAuditCollectExamplePictureRespVo> build = PageResult.<TpmAuditCollectExamplePictureRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmAuditCollectExamplePictureRespVo> query(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmAuditCollectExamplePictureReqVo tpmAuditCollectExamplePictureReqVo) {
                return doBack();
            }
        };
    }
}
