package com.biz.crm.tpm.budgetsubjects.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.tpm.budgetsubjects.TpmBudgetSubjectsFeign;
import com.biz.crm.nebular.tpm.budgetsubjects.req.TpmBudgetSubjectsReqVo;
import com.biz.crm.nebular.tpm.budgetsubjects.resp.TpmBudgetSubjectsRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 预算科目 feign接口熔断类
 *
 * @author huang.long
 * @date 2020-09-09 13:40:31
 */
@Slf4j
@Component
public class TpmBudgetSubjectsFeignImpl extends BaseAbstract implements FallbackFactory<TpmBudgetSubjectsFeign> {

    @Override
    public TpmBudgetSubjectsFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmBudgetSubjectsFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmBudgetSubjectsRespVo>> list(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
                doBack();
                PageResult<TpmBudgetSubjectsRespVo> build = PageResult.<TpmBudgetSubjectsRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmBudgetSubjectsRespVo> query(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
                return doBack();
            }
        };
    }
}
