package com.biz.crm.tpm.costtypefine.impl;

import com.biz.crm.common.DictItemVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.costtypefine.TpmCostTypeFineFeign;
import feign.hystrix.FallbackFactory;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.ArrayList;
import java.util.List;

/**
 * 活动细类 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-14 11:01:38
 */
@Slf4j
@Component
public class TpmCostTypeFineFeignImpl extends BaseAbstract implements FallbackFactory<TpmCostTypeFineFeign> {

    @Override
    public TpmCostTypeFineFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmCostTypeFineFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmCostTypeFineRespVo>> list(TpmCostTypeFineReqVo tpmCostTypeFineReqVo) {
                doBack();
                PageResult<TpmCostTypeFineRespVo> build = PageResult.<TpmCostTypeFineRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmCostTypeFineRespVo> query(TpmCostTypeFineReqVo tpmCostTypeFineReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmCostTypeFineReqVo tpmCostTypeFineReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmCostTypeFineReqVo tpmCostTypeFineReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmCostTypeFineReqVo tpmCostTypeFineReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmCostTypeFineReqVo tpmCostTypeFineReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmCostTypeFineReqVo tpmCostTypeFineReqVo) {
                return doBack();
            }

            /**
             * 核销申请中核销资料
             * @param fineCodes
             * @return
             */
            @Override
            public Result<TpmCostTypeFineRespVo> costTypeFineListByFineCode( List<String> fineCodes) {
                return doBack();
            }

            @PostMapping("/tpmcosttypefine/findCategoriesByFineCode")
            @Override
            public Result<PageResult<TpmCostTypeCategoriesRespVo>> findCategoriesByFineCode(TpmCostTypeFineReqVo reqVo) {
                return doBack();
            }

            /**
             * @Description 根据细类编码查询  ERP会计科目编码
             * @Date 2020/11/2
             * @Param [tpmCostTypeFineReqVo]
             * @return com.biz.crm.util.Result<java.util.List<com.biz.crm.common.DictItemVo>>
             **/
            @Override
            public Result<List<TpmCostTypeFineRespVo>> financeSubjectsErpCodeByFindCode(TpmAccountInvoiceReqVo reqVo) {
                return doBack();
            }
        };
    }
}
