package com.biz.crm.tpm.feebudget;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetDetailsRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetDetailsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.feebudget.impl.TpmFeeBudgetDetailsFeignImpl;

/**
 * 费用预算明细 feign接口
 *
 * @author huanglong
 * @date 2020-09-16 10:42:32
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmFeeBudgetDetailsFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmFeeBudgetDetailsFeignImpl.class)
public interface TpmFeeBudgetDetailsFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmfeebudgetdetails/list")
    Result<PageResult<TpmFeeBudgetDetailsRespVo>> list(@RequestBody TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmfeebudgetdetails/query")
    Result<TpmFeeBudgetDetailsRespVo> query(@RequestBody TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmfeebudgetdetails/save")
    Result save(@RequestBody TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmfeebudgetdetails/update")
    Result update(@RequestBody TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmfeebudgetdetails/delete")
    Result delete(@RequestBody TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmfeebudgetdetails/enable")
    Result enable(@RequestBody TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmfeebudgetdetails/disable")
    Result disable(@RequestBody TpmFeeBudgetDetailsReqVo tpmFeeBudgetDetailsReqVo);
}
