package com.biz.crm.tpm.fiscalyear.impl;

import com.biz.crm.nebular.tpm.budgetsubjects.resp.TpmBudgetSubjectsRespVo;
import com.biz.crm.tpm.fiscalyear.TpmFiscalYearSettingFeign;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.fiscalyear.resp.TpmFiscalYearSettingRespVo;
import com.biz.crm.nebular.tpm.fiscalyear.req.TpmFiscalYearSettingReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;

/**
 * 财年设置 财年设置表feign接口熔断类
 *
 * @author huang.long
 * @date 2020-09-08 11:19:03
 */
@Slf4j
@Component
public class TpmFiscalYearSettingFeignImpl extends BaseAbstract implements FallbackFactory<TpmFiscalYearSettingFeign> {

    @Override
    public TpmFiscalYearSettingFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmFiscalYearSettingFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmFiscalYearSettingRespVo>> list(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
                doBack();
                PageResult<TpmFiscalYearSettingRespVo> build = PageResult.<TpmFiscalYearSettingRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmFiscalYearSettingRespVo> query(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmFiscalYearSettingReqVo tpmFiscalYearSettingReqVo) {
                return doBack();
            }
        };
    }
}
