package com.biz.crm.tpm.income.impl;

import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.tpm.income.TpmIncomeBudgetFeign;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 收入预算;feign接口熔断类
 *
 * @author lf
 * @date 2021-02-02 17:55:15
 */
@Slf4j
@Component
public class TpmIncomeBudgetFeignImpl extends BaseAbstract implements FallbackFactory<TpmIncomeBudgetFeign> {

    @Override
    public TpmIncomeBudgetFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmIncomeBudgetFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmIncomeBudgetRespVo>> list(TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
                doBack();
                PageResult<TpmIncomeBudgetRespVo> build = PageResult.<TpmIncomeBudgetRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmIncomeBudgetRespVo> query(TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
                return doBack();
            }
        };
    }
}
