package com.biz.crm.tpm.scales.impl;

import com.biz.crm.nebular.tpm.sale.req.TpmSalesDataReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesDataRespVo;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.scales.TpmSalesDataFeign;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 实际销售数据 feign接口熔断类
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */
@Slf4j
@Component
public class TpmSalesDataFeignImpl extends BaseAbstract implements FallbackFactory<TpmSalesDataFeign> {

    @Override
    public TpmSalesDataFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmSalesDataFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmSalesDataRespVo>> list(TpmSalesDataReqVo tpmSalesDataReqVo) {
                doBack();
                PageResult<TpmSalesDataRespVo> build = PageResult.<TpmSalesDataRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmSalesDataRespVo> query(TpmSalesDataReqVo tpmSalesDataReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmSalesDataReqVo tpmSalesDataReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmSalesDataReqVo tpmSalesDataReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmSalesDataReqVo tpmSalesDataReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmSalesDataReqVo tpmSalesDataReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmSalesDataReqVo tpmSalesDataReqVo) {
                return doBack();
            }
        };
    }
}
