package com.biz.crm.activiti.act;

import com.biz.crm.activiti.act.impl.TaAgencyApprovalFeignImpl;
import com.biz.crm.nebular.activiti.act.req.TaAgencyApprovalReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaAgencyApprovalRespVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;


/**
 * feign接口
 *
 * @author jerry7
 * @date 2021-01-11 16:39:03
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TaAgencyApprovalFeign",name="crm-activiti",path = "activiti",fallbackFactory = TaAgencyApprovalFeignImpl.class)
public interface TaAgencyApprovalFeign {

    /**
     * 列表
     */
    @PostMapping("/taagencyapproval/list")
    Result<PageResult<TaAgencyApprovalRespVo>> list(@RequestBody TaAgencyApprovalReqVo taAgencyApprovalReqVo);

    /**
     * 查询
     */
    @PostMapping("/taagencyapproval/query")
    Result<TaAgencyApprovalRespVo> query(@RequestBody TaAgencyApprovalReqVo taAgencyApprovalReqVo);

    /**
     * 新增
     */
    @PostMapping("/taagencyapproval/save")
    Result save(@RequestBody TaAgencyApprovalReqVo taAgencyApprovalReqVo);

    /**
     * 更新
     */
    @PostMapping("/taagencyapproval/update")
    Result update(@RequestBody TaAgencyApprovalReqVo taAgencyApprovalReqVo);

    /**
     * 删除
     */
    @PostMapping("/taagencyapproval/delete")
    Result delete(@RequestBody TaAgencyApprovalReqVo taAgencyApprovalReqVo);

    /**
     * 启用
     */
    @PostMapping("/taagencyapproval/enable")
    Result enable(@RequestBody TaAgencyApprovalReqVo taAgencyApprovalReqVo);

    /**
     * 禁用
     */
    @PostMapping("/taagencyapproval/disable")
    Result disable(@RequestBody TaAgencyApprovalReqVo taAgencyApprovalReqVo);
}
