package com.biz.crm.activiti.design;

import com.biz.crm.activiti.design.impl.TaNodeConfigFeignImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.design.req.TaNodeConfigReqVo;
import com.biz.crm.nebular.activiti.design.resp.TaNodeConfigRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * feign接口
 *
 * @author jerry7
 * @date 2020-12-04 10:33:17
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "TaNodeConfigFeign", name = "crm-activiti", path = "activiti", fallbackFactory = TaNodeConfigFeignImpl.class)
public interface TaNodeConfigFeign {

    /**
     * 列表
     */
    @PostMapping("/tanodeconfig/list")
    Result<PageResult<TaNodeConfigRespVo>> list(@RequestBody TaNodeConfigReqVo taNodeConfigReqVo);

    /**
     * 查询
     */
    @GetMapping("/tanodeconfig/query")
    Result<TaNodeConfigRespVo> query(@RequestParam(value = "id", required = false) String id);

    /**
     * 新增
     */
    @PostMapping("/tanodeconfig/save")
    Result save(@RequestBody TaNodeConfigReqVo taNodeConfigReqVo);

    /**
     * 更新
     */
    @PostMapping("/tanodeconfig/update")
    Result update(@RequestBody TaNodeConfigReqVo taNodeConfigReqVo);

    /**
     * 删除
     */
    @PostMapping("/tanodeconfig/delete")
    Result delete(@RequestBody List<String> ids);

}
