package com.biz.crm.dms.notice;

import com.biz.crm.common.PageResult;
import com.biz.crm.dms.notice.impl.NoticeFeignImpl;
import com.biz.crm.nebular.dms.notice.NoticeVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;

/** 公告
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/9/27 16:03
 **/
@FeignClient(url ="${feign.urlip:}",qualifier = "noticeFeign",name="crm-dms",path = "dms",fallbackFactory = NoticeFeignImpl.class)
public interface NoticeFeign {

    /**
     * 新增
     */
    @PostMapping(value = "/m/notice/add")
    Result add(@RequestBody NoticeVo noticeVo);

    /**
     * 编辑
     */
    @PostMapping(value = "/m/notice/edit")
    Result edit(@RequestBody NoticeVo noticeVo);

    /**
     * 通过id查询
     */
    @GetMapping(value = "/m/notice/findById/{id}")
    Result<NoticeVo> findById(@PathVariable("id") String id);

    /**
     * 分页搜索公告
     */
    @PostMapping(value = "/m/notice/list")
    Result<PageResult<NoticeVo>> list(@RequestBody NoticeVo noticeVo);

    /**
     * 根据id批量删除
     */
    @PostMapping(value = "/m/notice/delByIds")
    Result<Object> delByIds(@RequestBody ArrayList<String> ids);

    /**
     * 根据查询条件批量删除
     */
    @PostMapping(value = "/m/notice/delByParam")
    Result<Object> delByParam(@RequestBody NoticeVo noticeVo);
}
