package com.biz.crm.dms.promotion;

import com.biz.crm.dms.promotion.impl.PromotionPolicyProductFeignImpl;
import com.biz.crm.nebular.dms.promotion.*;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * 促销政策商品
 *  @author: xi.peng
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "promotionPolicyProductFeign",name="crm-dms",path = "dms",fallbackFactory = PromotionPolicyProductFeignImpl.class)
public interface PromotionPolicyProductFeign {

    /**
     * 根据促销政策编码集合查询促销政策商品列表
     */
    @PostMapping("/promotion/policyproduct/selectListByPromotionPolicyCodes")
    Result<List<PromotionPolicyProductRespVo>> selectListByPromotionPolicyCodes(@RequestBody PromotionPolicyCodesVo reqVo);

}
